/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz.config;

import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.floragunn.codova.documents.patch.PatchableDocument;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.searchguard.authz.AuthorizationService;
import com.floragunn.searchguard.authz.config.RoleMapping;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchsupport.StaticSettings;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;

public class AuthorizationConfig
implements PatchableDocument<AuthorizationConfig> {
    static final Pattern DEFAULT_IGNORE_UNAUTHORIZED_INDICES_ACTIONS = Pattern.createUnchecked((String)"indices:data/read/*", (String)"indices:admin/mappings/fields/get", (String[])new String[]{"indices:admin/shards/search_shards", "indices:admin/resolve/index", "indices:admin/delete", "indices:admin/mapping/put", "indices:admin/settings/update", "indices:monitor/settings/get", "indices:monitor/stats", "indices:admin/upgrade", "indices:admin/refresh", "indices:admin/synced_flush", "indices:admin/aliases/get", "indices:admin/data_stream/get", "indices:admin/get"});
    static final Pattern DEFAULT_IGNORE_UNAUTHORIZED_INDICES_ACTIONS_ALLOWING_EMPTY_RESULT = Pattern.createUnchecked((String)"indices:data/read/*", (String)"indices:admin/mappings/fields/get", (String[])new String[]{"indices:admin/shards/search_shards", "indices:admin/resolve/index", "indices:monitor/settings/get", "indices:monitor/stats", "indices:admin/refresh", "indices:admin/synced_flush", "indices:admin/aliases/get", "indices:admin/data_stream/get", "indices:admin/get"});
    public static final AuthorizationConfig DEFAULT = new AuthorizationConfig(DocNode.EMPTY, true, DEFAULT_IGNORE_UNAUTHORIZED_INDICES_ACTIONS, DEFAULT_IGNORE_UNAUTHORIZED_INDICES_ACTIONS_ALLOWING_EMPTY_RESULT, null, RoleMapping.ResolutionMode.MAPPING_ONLY, false, MetricsLevel.BASIC);
    private final DocNode source;
    private final boolean ignoreUnauthorizedIndices;
    private final Pattern ignoreUnauthorizedIndicesActions;
    private final Pattern ignoreUnauthorizedIndicesActionsAllowingEmptyResult;
    private final String fieldAnonymizationSalt;
    private final boolean debugEnabled;
    private final MetricsLevel metricsLevel;
    private final RoleMapping.ResolutionMode roleMappingResolution;

    AuthorizationConfig(DocNode source, boolean ignoreUnauthorizedIndices, Pattern ignoreUnauthorizedIndicesActions, Pattern ignoreUnauthorizedIndicesActionsAllowingEmptyResult, String fieldAnonymizationSalt, RoleMapping.ResolutionMode roleMappingResolution, boolean debugEnabled, MetricsLevel metricsLevel) {
        this.source = source;
        this.ignoreUnauthorizedIndices = ignoreUnauthorizedIndices;
        this.ignoreUnauthorizedIndicesActions = ignoreUnauthorizedIndicesActions;
        this.ignoreUnauthorizedIndicesActionsAllowingEmptyResult = ignoreUnauthorizedIndicesActionsAllowingEmptyResult;
        this.fieldAnonymizationSalt = fieldAnonymizationSalt;
        this.roleMappingResolution = roleMappingResolution;
        this.debugEnabled = debugEnabled;
        this.metricsLevel = metricsLevel;
    }

    public static ValidationResult<AuthorizationConfig> parse(DocNode docNode, Parser.Context context) {
        ValidatingDocNode vNode;
        ValidationErrors validationErrors = new ValidationErrors();
        try {
            vNode = new ValidatingDocNode(docNode.splitDottedAttributeNamesToTree(), validationErrors);
        }
        catch (UnexpectedDocumentStructureException e) {
            return new ValidationResult(e.getValidationErrors());
        }
        boolean ignoreUnauthorizedIndices = vNode.get("ignore_unauthorized_indices.enabled").withDefault(true).asBoolean();
        Pattern ignoreUnauthorizedIndicesActions = (Pattern)vNode.get("ignore_unauthorized_indices.affected_actions").withDefault((Object)DEFAULT_IGNORE_UNAUTHORIZED_INDICES_ACTIONS).by(Pattern::parse);
        Pattern ignoreUnauthorizedIndicesActionsAllowingEmptyResult = (Pattern)vNode.get("ignore_unauthorized_indices.empty_result_allowed_for_actions").withDefault((Object)DEFAULT_IGNORE_UNAUTHORIZED_INDICES_ACTIONS_ALLOWING_EMPTY_RESULT).by(Pattern::parse);
        String fieldAnonymizationSalt = vNode.get("field_anonymization.salt").asString();
        RoleMapping.ResolutionMode roleMappingResolution = (RoleMapping.ResolutionMode)vNode.get("role_mapping.resolution_mode").withDefault((Enum)RoleMapping.ResolutionMode.MAPPING_ONLY).asEnum(RoleMapping.ResolutionMode.class);
        boolean debugEnabled = vNode.get("debug").withDefault(false).asBoolean();
        MetricsLevel metricsLevel = (MetricsLevel)vNode.get("metrics").withDefault((Enum)MetricsLevel.BASIC).asEnum(MetricsLevel.class);
        if (!validationErrors.hasErrors()) {
            return new ValidationResult((Object)new AuthorizationConfig(docNode, ignoreUnauthorizedIndices, ignoreUnauthorizedIndicesActions, ignoreUnauthorizedIndicesActionsAllowingEmptyResult, fieldAnonymizationSalt, roleMappingResolution, debugEnabled, metricsLevel));
        }
        return new ValidationResult(validationErrors);
    }

    public static AuthorizationConfig parseLegacySgConfig(DocNode docNode, Parser.Context context, StaticSettings settings) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(docNode.splitDottedAttributeNamesToTree(), validationErrors);
        String fieldAnonymizationSalt = vNode.get("dynamic.field_anonymization_salt2").asString();
        validationErrors.throwExceptionForPresentErrors();
        return new AuthorizationConfig(docNode, true, DEFAULT_IGNORE_UNAUTHORIZED_INDICES_ACTIONS, DEFAULT_IGNORE_UNAUTHORIZED_INDICES_ACTIONS_ALLOWING_EMPTY_RESULT, fieldAnonymizationSalt, AuthorizationConfig.getRolesMappingResolution(settings), false, MetricsLevel.BASIC);
    }

    public boolean isIgnoreUnauthorizedIndices() {
        return this.ignoreUnauthorizedIndices;
    }

    public Object toBasicObject() {
        return this.source;
    }

    public String toString() {
        return this.toJsonString();
    }

    public String getFieldAnonymizationSalt() {
        return this.fieldAnonymizationSalt;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public AuthorizationConfig parseI(DocNode docNode, Parser.Context context) throws ConfigValidationException {
        return (AuthorizationConfig)AuthorizationConfig.parse(docNode, (ConfigurationRepository.Context)context).get();
    }

    public MetricsLevel getMetricsLevel() {
        return this.metricsLevel;
    }

    public Pattern getIgnoreUnauthorizedIndicesActions() {
        return this.ignoreUnauthorizedIndicesActions;
    }

    public Pattern getIgnoreUnauthorizedIndicesActionsAllowingEmptyResult() {
        return this.ignoreUnauthorizedIndicesActionsAllowingEmptyResult;
    }

    private static RoleMapping.ResolutionMode getRolesMappingResolution(StaticSettings settings) {
        try {
            return RoleMapping.ResolutionMode.valueOf(((String)settings.get(AuthorizationService.ROLES_MAPPING_RESOLUTION)).toUpperCase());
        }
        catch (Exception e) {
            return RoleMapping.ResolutionMode.MAPPING_ONLY;
        }
    }

    public RoleMapping.ResolutionMode getRoleMappingResolution() {
        return this.roleMappingResolution;
    }
}

